package gov.va.med.mhv.vitals.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.vitals.enums.OxygenDeviceEnumeraion;
import gov.va.med.mhv.vitals.enums.SymptomsEnumeration;

@XmlRootElement(name = "PulseOximetryReadingDTO")
public class PulseOximetryReadingDTO extends AbstractDTO implements Serializable{
	
	private static final long serialVersionUID = -6240183527002003798L;
	
	private Long pulseOximetryId;
	private String comments;
	private OxygenDeviceEnumeraion suppOxygenDevice = OxygenDeviceEnumeraion.N;
	private Integer oxygenSetting;
	private Integer respiratoryRate;
	private Integer oximeterReading;
	private String otherSymptoms;
	private SymptomsEnumeration symptoms = SymptomsEnumeration.N;
	private Long userprofileId;
	public Long getPulseOximetryId() {
		return pulseOximetryId;
	}
	public void setPulseOximetryId(Long pulseOximetryId) {
		this.pulseOximetryId = pulseOximetryId;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getSuppOxygenDevice() {
		return suppOxygenDevice.name();
	}
	public void setSuppOxygenDevice(String suppOxygenDevice) {
		this.suppOxygenDevice = OxygenDeviceEnumeraion.valueOf(suppOxygenDevice);
	}
	public Integer getOxygenSetting() {
		return oxygenSetting;
	}
	public void setOxygenSetting(Integer oxygenSetting) {
		this.oxygenSetting = oxygenSetting;
	}
	public Integer getRespiratoryRate() {
		return respiratoryRate;
	}
	public void setRespiratoryRate(Integer respiratoryRate) {
		this.respiratoryRate = respiratoryRate;
	}
	public Integer getOximeterReading() {
		return oximeterReading;
	}
	public void setOximeterReading(Integer oximeterReading) {
		this.oximeterReading = oximeterReading;
	}
	public String getOtherSymptoms() {
		return otherSymptoms;
	}
	public void setOtherSymptoms(String otherSymptoms) {
		this.otherSymptoms = otherSymptoms;
	}
	public String getSymptoms() {
		return symptoms.name();
	}
	public void setSymptoms(String symptoms) {
		this.symptoms = SymptomsEnumeration.valueOf(symptoms);
	}
	public Long getUserprofileId() {
		return userprofileId;
	}
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	@JsonIgnore
	public OxygenDeviceEnumeraion[] getOxygenDevices() {
		return OxygenDeviceEnumeraion.values();
	}
	@JsonIgnore
	public SymptomsEnumeration[] getAllSymptoms() {
		return SymptomsEnumeration.values();
	}
	@JsonIgnore
	public String getDisplaySuppOxygenDevice() {
		return this.suppOxygenDevice.getDescription();
	}

}
